#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/*********************************************************************
* Function Name  :  CloseOC4                                         *
* Description    :  This routine disables the Output Compare and its *
*                   interrupt bits.                                  *
* Parameters     :  None                                             *
* Return Value   :  None                                             *
*********************************************************************/

void CloseOC4()
{   
    IEC1bits.OC4IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC4CONbits.OCM = 0;/* Turn off Output Compare 4 */
    IFS1bits.OC4IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

#endif
